import json
import requests

# API「データベース一覧取得」を呼び出す
cmd = "https://api.bridge.nihu.jp/v1/integratedsearch/databases/list"
response = requests.post(cmd, json='')
result = response.json()

# 検索結果を画面に出力する（pretty printing）
#print(json.dumps(result, indent=2, ensure_ascii=False))

# 機関名とデータベース名の一覧を表示する
print('No.,データベースID,データベース名,所蔵機関')
i = 1
for institute in result['institute']:
    for database in institute['database']:
        print(f'{i},{database["databaseSearchId"]},{database["databaseName"]},{institute["instituteName"]}')
        i = i + 1
