import json
import requests

# 検索条件
query_1 = {
    'query': {
        'conditions': [
            {
                'query': {
                    'field': "title",
                    'term': "横浜",
                    'match': "contain" # 部分一致：異体字同定を行う
                }
            }
        ]
    }
}
query_2 = {
    'query': {
        'conditions': [
            {
                'query': {
                    'field': "title",
                    'term': "横浜",
                    'match': "regex" # 正規表現：異体字同定を行わない
                }
            }
        ]
    }
}

# API「メタデータ検索(HIT数)」を呼び出す
cmd = "https://api.bridge.nihu.jp/v1/integratedsearch/metadata/search-hits"
result_1 = requests.post(cmd, json=query_1).json()
result_2 = requests.post(cmd, json=query_2).json()

# 検索結果を画面に出力する（pretty printing）
print(json.dumps(result_1, indent=2, ensure_ascii=False))
print(json.dumps(result_2, indent=2, ensure_ascii=False))
