import json
import requests

# 検索条件
query = {
    'query': {
        'conditions': [
            {
                'query': {
                    'term': '堀浩一'
                }
            }
        ],
        'fields': [
            "title",
            "creator"
        ],
        'paging': {
            'size': 1000
        }
    }
}

# API「メタデータ検索」を呼び出す
cmd = "https://api.bridge.nihu.jp/v1/integratedsearch/metadata/search"
response = requests.post(cmd, json=query)
result = response.json()

# 検索結果を画面に出力する（pretty printing）
print(json.dumps(result, indent=2, ensure_ascii=False))
