import json
import requests

# 検索条件
query = {
    'query': {
        'conditions': [
            {
                'query': {
                    'field': "title",
                    'term': "三十三間堂",
                    'match': "contain"
                }
            }
        ]
    }
}

# API「メタデータ検索(HIT数)」を呼び出す
cmd = "https://api.bridge.nihu.jp/v1/integratedsearch/metadata/search-hits"
response = requests.post(cmd, json=query)
result = response.json()

# 検索結果を画面に出力する（pretty printing）
print(json.dumps(result, indent=2))
