import json
import requests

# 和暦検索
# 和暦を指定
wadate_keyword = "文政"
wadate_type = "年間"

wadate_type_str = {
    '日': 'day',
    '月': 'month',
    '年': "year",
    '年間': "era"
}

# 区間の最初の日と最後の日を求める
date_query_1 = {
    "jsonrpc": "2.0",
    "method": "info",
    "params": {
        "ical": "1001.1", # 和暦（南朝）
        "itype": wadate_type_str[wadate_type],
        "ival": wadate_keyword,
        "oprop": "begin;end"
    },
    "id": "2022120901"
}

# Hutime Web API を呼び出す
cmd = "http://ap.hutime.org/cal/"
response = requests.post(cmd, json=date_query_1)
date_result_1 = response.json()
#print(json.dumps(date_result_1, indent=2, ensure_ascii=False))

# 開始日と終了日（和暦表記）
wadate_start = date_result_1['result'][0]['begin']
wadate_end = date_result_1['result'][0]['end']
#print(wadate_start, wadate_end)

# グレゴリオ暦に変換する：ISO 8601の規定に従う
date_query_2 = {
    "jsonrpc": "2.0",
    "method": "conv",
    "params": {
        "ical": "1001.1", # 和暦（南朝）
        "itype": "date",
        "ival": wadate_start + f'\r\n' + wadate_end,
        "ocal": "2.1", # グレゴリオ暦
        "otype": "date",
        "oprop": "text",
        "oform": "yyyy-MM-dd"
    },
    "id": "2022120902"
}
#print(date_query_2['params']['ival'])

# Hutime Web API を呼び出す
response = requests.post(cmd, json=date_query_2)
date_result_2 = response.json()
#print(json.dumps(date_result_2, indent=2, ensure_ascii=False))

# 開始日と終了日（グレゴリオ暦表記）
date_start = date_result_2['result'][0]['text']
date_end = date_result_2['result'][1]['text']

print(f'{wadate_keyword}[{wadate_type}]は{date_start}({wadate_start})から{date_end}({wadate_end})まで')

# ISO 8601形式による時間表記で「開始時間，終了時間」を与える
date_range = f'{date_start}T00:00:00+09:00,{date_end}T23:59:59+09:00'

# データベースの検索条件
query = {
    'database': [
        "nmjh_kanzounisikie",
        "ircjs_ukiyoe"
    ],
    'query': {
        'conditions': [
            {
                'query': {
                    'field': "temporal",
                    'term': date_range,
                    'operator': "BETWEEN"
                }
            }
        ],
        'fields': [
            "title",
            "creator",
            "temporal"
        ],
        'paging': {
            'size': 1
        }
    }
}

# API「メタデータ検索」を呼び出す
cmd = "https://api.bridge.nihu.jp/v1/integratedsearch/metadata/search"
response = requests.post(cmd, json=query)
result = response.json()

# 検索結果を画面に出力する（pretty printing）
print(json.dumps(result, indent=2, ensure_ascii=False))
